/*
 * Decompiled with CFR 0.152.
 */
package scientific;

import com.nokia.mid.appl.calc2.Local;
import common.control.Calculator2;
import common.control.DisplayManager;
import common.control.SettingsManager;
import common.misc.GlobalParameters;
import common.ui.CalculatorCanvas;
import common.ui.DisplaySizes;
import common.ui.InstructionsForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import scientific.ScientificButtonPanel;
import scientific.ScientificEditPanel;

public final class ScientificCanvas
extends CalculatorCanvas {
    public static final int ID = 1;
    private static final Command COMMAND_DISPLAY_IN_RADIANS = new Command(Local.getText(19), 1, 0);
    private static final Command COMMAND_DISPLAY_IN_DEGREES = new Command(Local.getText(18), 1, 0);
    private static final Command COMMAND_STANDARD_CALCULATOR = new Command(Local.getText(22), 1, 1);
    private Alert alert;

    public ScientificCanvas(Calculator2 midlet) {
        super(midlet);
        this.setTitle(Local.getText(28));
        this.addCommands(false);
        this.editPanel = new ScientificEditPanel(this.displaySize);
        this.buttonPanel = new ScientificButtonPanel(this.displaySize);
        this.editPanel.setCalculatorCanvas(this);
        this.buttonPanel.setCalculatorCanvas(this);
        this.buttonPanel.setEditPanel(this.editPanel);
    }

    public void paint(Graphics g) {
        if (this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(0);
        }
        super.paint(g);
        this.buttonPanel.paint(g);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == GlobalParameters.COMMAND_EXIT) {
            this.showConfirmation("Confirmation", "Really exit?");
        } else if (c == COMMAND_CLEAR) {
            this.editPanel.removeLastSymbol();
        } else if (c == GlobalParameters.COMMAND_SELECT) {
            this.buttonPanel.commandAction(c, d);
        } else if (c == COMMAND_DISPLAY_IN_DEGREES) {
            if (this.editPanel instanceof ScientificEditPanel) {
                ((ScientificEditPanel)this.editPanel).setUseDegrees(true);
            }
            this.removeCommand(COMMAND_DISPLAY_IN_DEGREES);
            this.addCommand(COMMAND_DISPLAY_IN_RADIANS);
        } else if (c == COMMAND_DISPLAY_IN_RADIANS) {
            if (this.editPanel instanceof ScientificEditPanel) {
                ((ScientificEditPanel)this.editPanel).setUseDegrees(false);
            }
            this.removeCommand(COMMAND_DISPLAY_IN_RADIANS);
            this.addCommand(COMMAND_DISPLAY_IN_DEGREES);
        } else if (c == COMMAND_STANDARD_CALCULATOR) {
            DisplayManager.getInstance().pop();
            DisplayManager.getInstance().push((Displayable)this.midlet.getStandardCalculator());
            SettingsManager.getInstance().setDefaultCalculatorMode(0);
        } else if (c == COMMAND_LOAN_CALCULATOR) {
            if (SettingsManager.getInstance().isLoanCalculatorDisplayedFirstTime()) {
                DisplayManager.getInstance().push((Displayable)new InstructionsForm(this.midlet, true, Local.getText(1)));
            } else {
                DisplayManager.getInstance().pop();
                DisplayManager.getInstance().push((Displayable)this.midlet.getLoanCalculator());
            }
        } else if (c == GlobalParameters.COMMAND_INSTRUCTIONS) {
            DisplayManager.getInstance().push((Displayable)new InstructionsForm(this.midlet, false, Local.getText(0)));
        }
    }

    protected void keyRepeated(int keyCode) {
        super.keyRepeated(keyCode);
        this.keyPressed(keyCode);
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (gameAction == 8 && keyCode != 53 && (this.displaySize.equals(DisplaySizes.S60_3_1) || this.displaySize.equals(DisplaySizes.S60_3_1_OLD))) {
            this.buttonPanel.commandAction(GlobalParameters.COMMAND_SELECT, (Displayable)this);
        }
        if (gameAction == 8 && this.displaySize.equals(DisplaySizes.S60_3_2_LANDSCAPE_SDK)) {
            this.buttonPanel.commandAction(GlobalParameters.COMMAND_SELECT, (Displayable)this);
        } else if (keyCode == -8 || keyCode == 8) {
            this.editPanel.removeLastSymbol();
        }
        this.editPanel.keyPressed(keyCode, gameAction);
        this.buttonPanel.keyPressed(keyCode, gameAction);
        this.repaint();
    }

    private void addCommands(boolean clear) {
        this.setCommandListener(this);
        this.addCommand(GlobalParameters.COMMAND_EXIT);
        this.addCommand(GlobalParameters.COMMAND_SELECT);
        this.addCommand(COMMAND_DISPLAY_IN_RADIANS);
        this.addCommand(COMMAND_STANDARD_CALCULATOR);
        this.addCommand(COMMAND_LOAN_CALCULATOR);
        this.addCommand(GlobalParameters.COMMAND_INSTRUCTIONS);
    }

    private void closeAlert() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.alert = null;
    }

    protected void showConfirmation(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    ScientificCanvas.this.closeAlert();
                    ScientificCanvas.this.midlet.notifyDestroyed();
                }
                if (c.getLabel().equals("No")) {
                    ScientificCanvas.this.closeAlert();
                }
            }
        });
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.alert, (Displayable)this);
    }
}

